CONTAINER Xhatchingshader
{
	NAME Xhatchingshader;

	INCLUDE Mpreview;
	INCLUDE Xbase;

	GROUP ID_SHADERPROPERTIES
	{
		COLUMNS 3;

		SHADERLINK HATCHINGSHADER_TEXTURE { FIT_H; }
		STATICTEXT { JOINEND; }
		STATICTEXT { JOINENDSCALE; }
		STATICTEXT { NEWLINE; }

		BOOL HATCHINGSHADER_TILE { }
		BOOL HATCHINGSHADER_ROTATIONAL { }
		STATICTEXT { NEWLINE; }

		REAL HATCHINGSHADER_SCALE { UNIT PERCENT; MIN 0.0; }
		REAL HATCHINGSHADER_ROTATE { UNIT DEGREE; MIN -360.0; MAX 360.0; }
		STATICTEXT { NEWLINE; }

		SEPARATOR { }
		STATICTEXT { NEWLINE; }

		REAL HATCHINGSHADER_OFFSET_U { UNIT PERCENT; }
		REAL HATCHINGSHADER_OFFSET_V { UNIT PERCENT; }
		STATICTEXT { NEWLINE; }

		SEPARATOR { }
		STATICTEXT { NEWLINE; }

		REAL HATCHINGSHADER_DENSITY { UNIT PERCENT; MIN 0.0; MAX 10000.0; }
		STATICTEXT { NEWLINE; }

		REAL HATCHINGSHADER_DENSITY_U { UNIT PERCENT; MIN 0.0; MAX 100.0; }
		REAL HATCHINGSHADER_DENSITY_V { UNIT PERCENT; MIN 0.0; MAX 100.0; }
		STATICTEXT { NEWLINE; }

		SEPARATOR { }
		STATICTEXT { NEWLINE; }

		REAL HATCHINGSHADER_SCATTER_U { UNIT PERCENT; MIN 0.0; }
		REAL HATCHINGSHADER_SCATTER_V { UNIT PERCENT; MIN 0.0; }
		STATICTEXT { NEWLINE; }

		REAL HATCHINGSHADER_SPACE_U { UNIT PERCENT; MIN -100.0; }
		REAL HATCHINGSHADER_SPACE_U_VAR { UNIT PERCENT; MIN 0.0; }
		STATICTEXT { NEWLINE; }

		REAL HATCHINGSHADER_SPACE_V { UNIT PERCENT; MIN -100.0; }
		REAL HATCHINGSHADER_SPACE_V_VAR { UNIT PERCENT; MIN 0.0; }
		STATICTEXT { NEWLINE; }

		REAL HATCHINGSHADER_SCALE_U { UNIT PERCENT; MIN 0.0; }
		REAL HATCHINGSHADER_SCALE_U_VAR { UNIT PERCENT; MIN 0.0; }
		STATICTEXT { NEWLINE; }

		REAL HATCHINGSHADER_SCALE_V { UNIT PERCENT; MIN 0.0; }
		REAL HATCHINGSHADER_SCALE_V_VAR { UNIT PERCENT; MIN 0.0; }
		STATICTEXT { NEWLINE; }

		REAL HATCHINGSHADER_STOKE_ROTATE { UNIT DEGREE; MIN 0.0; MAX 360.0; }	
		STATICTEXT { NEWLINE; }

		BOOL HATCHINGSHADER_CROSSED { }
		REAL HATCHINGSHADER_CROSS_ROTATE { UNIT DEGREE; MIN -360.0; MAX 360.0; }
	}
	
	GROUP HATCHINGSHADER_GROUP_COLOR
	{
		COLUMNS 1;

		COLOR HATCHINGSHADER_STROKE_COLOR { OPEN; }
		COLOR HATCHINGSHADER_STROKELIGHT_COLOR { OPEN; }
		COLOR HATCHINGSHADER_BACK_COLOR { OPEN; }
	}

	GROUP HATCHINGSHADER_GROUP_LIGHTING
	{
		COLUMNS 1;

		GROUP
		{
			COLUMNS 2;

			BOOL HATCHINGSHADER_DARK_STROKES { }
			BOOL HATCHINGSHADER_LIGHT_STROKES { }
		}

		GROUP
		{
			COLUMNS 2;

			LONG HATCHINGSHADER_LEVELS { MIN 1; MAX 20; }
			REAL HATCHINGSHADER_THRESHOLD { UNIT PERCENT; MIN 0.0; MAX 100.0; }
		}

		GRADIENT HATCHINGSHADER_SHADOW { ALPHA; ICC_BASEDOCUMENT; }
		GRADIENT HATCHINGSHADER_DIFFUSE { ALPHA; ICC_BASEDOCUMENT; }
		GRADIENT HATCHINGSHADER_SPEC { ALPHA; ICC_BASEDOCUMENT; }
		GRADIENT HATCHINGSHADER_ILLUM { ALPHA; ICC_BASEDOCUMENT; }

		GROUP
		{
			COLUMNS 2;

			BOOL HATCHINGSHADER_BUMP { }

			BOOL HATCHINGSHADER_CAMERA { }
			BOOL HATCHINGSHADER_LIGHTS { }
			BOOL HATCHINGSHADER_SPECULAR { }

			BOOL HATCHINGSHADER_ILLUMINATION { }
			BOOL HATCHINGSHADER_SHADOWS { }

			BOOL HATCHINGSHADER_CONTRAST { }
		}

		LONG HATCHINGSHADER_INCEXC
		{
			CYCLE
			{
				HATCHINGSHADER_INCEXC_INCLUDE;
				HATCHINGSHADER_INCEXC_EXCLUDE;
			}
		}

		IN_EXCLUDE  HATCHINGSHADER_INCEXC_LIGHTS
		{
			NUM_FLAGS 0; INIT_STATE 0; SEND_SELCHNGMSG 1;
			ACCEPT { Olight; };
		}
	}
}